/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mlib.data.IReader;
import com.mlib.data.ISerializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

record DataList<Type>(Getter<Type> getter, Setter<Type> setter, IReader<Type> reader) implements ISerializable
{
    @Override
    public void read(JsonElement element) {
        JsonArray jsonArray = element.getAsJsonArray();
        ArrayList<Type> values = new ArrayList<Type>();
        for (JsonElement subelement : jsonArray) {
            values.add(this.reader.read(subelement));
        }
        this.setter.accept(values);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_236828_((Collection)this.getter.get(), this.reader::write);
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.setter.accept((List)buffer.m_236838_(ArrayList::new, this.reader::read));
    }

    @Override
    public void write(Tag tag) {
        ListTag listTag = (ListTag)tag;
        List values = (List)this.getter.get();
        for (Object value : values) {
            listTag.add((Object)this.reader.write(value));
        }
    }

    @Override
    public void read(Tag tag) {
        ListTag listTag = (ListTag)tag;
        ArrayList<Type> values = new ArrayList<Type>();
        for (Tag subtag : listTag) {
            values.add(this.reader.read(subtag));
        }
        this.setter.accept(values);
    }

    public static interface Getter<Type>
    extends Supplier<List<Type>> {
    }

    public static interface Setter<Type>
    extends Consumer<List<Type>> {
    }
}

